/*********************************************************************
 *
 *	Hardware specific definitions
 *
 *********************************************************************
 * FileName:        HardwareProfile.h
 * Dependencies:    None
 * Processor:       dsPIC33FJ128GP708
 * Complier:        Microchip C30 v2.05 or higher
 * Company:         Microchip Technology, Inc.
 *
 * Software License Agreement
 *
 * Copyright  2002-2007 Microchip Technology Inc.  All rights 
 * reserved.
 *
 * Microchip licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when embedded on a Microchip microcontroller or 
 *      digital signal controller product (Device) which is 
 *      integrated into Licensees product; or
 * (ii) ONLY the Software driver source files ENC28J60.c and 
 *      ENC28J60.h ported to a non-Microchip device used in 
 *      conjunction with a Microchip ethernet controller for the 
 *      sole purpose of interfacing with the ethernet controller. 
 *
 * You should refer to the license agreement accompanying this 
 * Software for additional information regarding your rights and 
 * obligations.
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED AS IS WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * MICROCHIP BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 *
 * Author               Date		Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Howard Schlunder		10/03/06	Original, copied from Compiler.h
 ********************************************************************/
#ifndef __HARDWARE_PROFILE_H
#define __HARDWARE_PROFILE_H

#define DSPIC33WEB_V1										// ET-dsPIC33WEB V1.0

// Clock frequency value.
// This value is used to calculate Tick Counter value
#if defined(__dsPIC33F__)
	#define CLOCK_FREQ	(80000000)      					// Clock Frequency = 80 MHz
#endif

// Hardware Interface Mappings For Web Server Control Project
// ET-dSPIC33WEB-V1 (dsPIC33FJ128GP708 + ENC28J60 + 25LC256)
#if defined(DSPIC33WEB_V1)
    #define LED0_TRIS			(TRISBbits.TRISB8)			// RB8 = LED1
	#define LED0_IO				(LATBbits.LATB8)	
	#define LED1_TRIS			(TRISBbits.TRISB9)			// RB9 = LED2
	#define LED1_IO				(LATBbits.LATB9)
	#define LED2_TRIS			(TRISBbits.TRISB10)			// RB10 = LED3
	#define LED2_IO				(LATBbits.LATB10)
	#define LED3_TRIS			(TRISBbits.TRISB11)			// RB11 = LED4
	#define LED3_IO				(LATBbits.LATB11)
	#define LED4_TRIS			(TRISBbits.TRISB12)			// RB12 = LED5
	#define LED4_IO				(LATBbits.LATB12)
	#define LED5_TRIS			(TRISBbits.TRISB13)			// RB13 = LED6
	#define LED5_IO				(LATBbits.LATB13)
	#define LED6_TRIS			(TRISBbits.TRISB14)			// RB14 = LED7
	#define LED6_IO				(LATBbits.LATB14)
	#define LED7_TRIS			(TRISBbits.TRISB15)			// RB15 = LED8	
	#define LED7_IO				(LATBbits.LATB15)
	#define LED_IO				(*((volatile unsigned char*)(&PORTB)))

	#define BUTTON0_TRIS		(TRISDbits.TRISD8)			// RD8 = SW1
	#define	BUTTON0_IO			(PORTDbits.RD8)
	#define BUTTON1_TRIS		(TRISDbits.TRISD9)			// RD9 = SW2	
	#define	BUTTON1_IO			(PORTDbits.RD9)
	#define BUTTON2_TRIS		(TRISDbits.TRISD10)			// RD10 = SW3
	#define	BUTTON2_IO			(PORTDbits.RD10)
	#define BUTTON3_TRIS		(TRISDbits.TRISD11)			// RD11 = SW4
	#define	BUTTON3_IO			(PORTDbits.RD11)

	#define UARTTX_TRIS			(TRISFbits.TRISF5)			// RF5 = TX RS232-CH2
	#define UARTTX_IO			(PORTFbits.RF5)
	#define UARTRX_TRIS			(TRISFbits.TRISF4)			// RF4 = RX RS232-CH2	
	#define UARTRX_IO			(PORTFbits.RF4)
    
	// SPI Ethernet ENC28J60 I/O Interface(SPI1)
	#define ENC_RST_TRIS		(TRISDbits.TRISD15)			// RD15 = Output = RST (Not Used Now)
	#define ENC_RST_IO			(PORTDbits.RD15)
	#define ENC_CS_TRIS			(TRISDbits.TRISD14)			// RD14 = Output = CS
	#define ENC_CS_IO			(PORTDbits.RD14)
	#define ENC_SCK_TRIS		(TRISFbits.TRISF6)			// RF6 = SCK1
	#define ENC_SDI_TRIS		(TRISFbits.TRISF7)			// RF7 = SDI1
	#define ENC_SDO_TRIS		(TRISFbits.TRISF8)			// RF8 = SDO1
	#define ENC_SPI_IF			(IFS0bits.SPI1IF)			// SPI1 Register & Status
	#define ENC_SSPBUF			(SPI1BUF)
	#define ENC_SPISTAT			(SPI1STAT)
	#define ENC_SPISTATbits		(SPI1STATbits)
	#define ENC_SPICON1			(SPI1CON1)
	#define ENC_SPICON1bits		(SPI1CON1bits)
	#define ENC_SPICON2			(SPI1CON2)

	// SPI EEPROM 25LC256 I/O Interface(SPI2)
	#define EEPROM_CS_TRIS		(TRISDbits.TRISD12)			// RD12 = Output = CS
	#define EEPROM_CS_IO		(PORTDbits.RD12)
	#define EEPROM_SCK_TRIS		(TRISGbits.TRISG6)			// RG6 = SCK2
	#define EEPROM_SDI_TRIS		(TRISGbits.TRISG7)			// RG7 = SDI2
	#define EEPROM_SDO_TRIS		(TRISGbits.TRISG8)			// RG8 = SDO2
	#define EEPROM_SPI_IF		(IFS2bits.SPI2IF)			// SPI2 Register & Status
	#define EEPROM_SSPBUF		(SPI2BUF)
	#define EEPROM_SPICON1		(SPI2CON1)
	#define EEPROM_SPICON1bits	(SPI2CON1bits)
	#define EEPROM_SPICON2		(SPI2CON2)
	#define EEPROM_SPISTAT		(SPI2STAT)
	#define EEPROM_SPISTATbits	(SPI2STATbits)

	// Character LCD Module I/O Interface
	typedef struct
	{
		unsigned char data : 4;								// Bits 0 through 3
		unsigned char : 4;									// Bits 4 through 7
    
	} LCD_DATA;

	#define LCD_DATA_TRIS		(((LCD_DATA*)&TRISD)->data)	// RD0..RD3 = Data Bit
	#define LCD_DATA_IO			(((LCD_DATA*)&LATD)->data)
	#define LCD_RS_TRIS			(TRISDbits.TRISD4)			// RD4 = RS
	#define LCD_RS_IO			(LATDbits.LATD4)
	#define LCD_RD_WR_TRIS		(TRISDbits.TRISD5)			// RD5 = RW
	#define LCD_RD_WR_IO		(LATDbits.LATD5)
	#define LCD_E_TRIS			(TRISDbits.TRISD6)			// RD6 = EN
	#define LCD_E_IO			(LATDbits.LATD6)

#else
	#error "Hardware profile not defined.  See available profiles in HardwareProfile.h.  Add the appropriate macro definition to your application configuration file ('TCPIPConfig.h', etc.)"
#endif

// Define UART Function used with Stack 
#if defined(__C30__)
	#define UBRG					U2BRG
	#define UMODE					U2MODE
	#define USTA					U2STA
	#define BusyUART()				BusyUART2()
	#define CloseUART()				CloseUART2()
	#define ConfigIntUART(a)		ConfigIntUART2(a)
	#define DataRdyUART()			DataRdyUART2()
	#define OpenUART(a,b,c)			OpenUART2(a,b,c)
	#define ReadUART()				ReadUART2()
	#define WriteUART(a)			WriteUART2(a)
	#define getsUART(a,b,c)			getsUART2(a,b,c)
	#define putsUART(a)				putsUART2((unsigned int *)a)
	#define getcUART()				getcUART2()
	#define putcUART(a)				WriteUART2(a)
	#define putrsUART(a)			putsUART2((unsigned int *)a)
#endif

// Various compilation warnings specific to the TCP/IP stack
#if ((defined(__dsPIC33F__)) && !defined(DSPIC33WEB_V1))
	#error "Warning: The board profile may not be configured correctly."
	#error
	#error "Make sure that a proper board profile macro is defined at the top of 'TCPIPConfig.h' and your processor is selected correctly in MPLAB."
#endif

#endif
